<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// deezer, itunes, spotify or azuracast.
$ApiType = "deezer";

// Valores por defecto.
$defaultArtist = "No Disponible";
$defaultTitle = "Artista";
$defaultArtwork = "https://miradioenvivo.com/api/bloqueado/noimagen.png";

// Lista de anuncios personalizados con sus respectivas imágenes
$ads = [
    "CONTACTENOS: +51944402637" => [
        "artist" => "URL BLOQUEADA",
        "artwork" => "https://miradioenvivo.com/api/bloqueado/noimagen.png"
    ]
];

$GetDataInput = filter_input(INPUT_GET, 'query');
$FilterReplace = str_replace(array('.mp3', '.aac', '.wav'), '', $GetDataInput);

function checkForAd($query, $ads)
{
    foreach ($ads as $songTitle => $adData) {
        if (stripos($query, $songTitle) !== false && stripos($query, $adData['artist']) !== false) {
            return json_encode(array(
                'results' => array(
                    'artist' => $adData['artist'],
                    'title' => $songTitle,
                    'artwork' => $adData['artwork']
                )
            ));
        }
    }
    return null;
}

$adResponse = checkForAd($FilterReplace, $ads);
if ($adResponse) {
    echo $adResponse;
    exit;
}

function getDeezer($DataInputDeezer, $defaultArtist, $defaultTitle, $defaultArtwork)
{
    $url = 'https://api.deezer.com/search?q=' . urlencode($DataInputDeezer);
    $FGC = @file_get_contents($url);
    $JSD = json_decode($FGC);

    $artist = $JSD->data[0]->artist->name ?? $defaultArtist;
    $title = $JSD->data[0]->title ?? $defaultTitle;
    $artwork = $JSD->data[0]->album->cover_xl ?? $defaultArtwork;
    $stream = $JSD->data[0]->link ?? null;
    $albumId = $JSD->data[0]->album->id ?? null;

    $year = "Desconocido";
    $genre = "Desconocido";
    $album = "Desconocido";

    // Si hay un ID de álbum, obtenemos más detalles
    if ($albumId) {
        $albumUrl = "https://api.deezer.com/album/" . $albumId;
        $AlbumData = @file_get_contents($albumUrl);
        $AlbumJson = json_decode($AlbumData);
        
        if (isset($AlbumJson->release_date)) {
            $year = substr($AlbumJson->release_date, 0, 4);
        }
        
        if (!empty($AlbumJson->genres->data)) {
            $genreList = array_map(function ($g) {
                return $g->name;
            }, $AlbumJson->genres->data);
            $genre = implode(", ", $genreList);
        }
        
        if (!empty($AlbumJson->title)) {
            $album = $AlbumJson->title;
        }
    }

    return json_encode(array(
        'results' => array(
            'artist' => $artist,
            'title' => $title,
            'artwork' => $artwork,
            'stream' => $stream,
            'album' => $album,
            'year' => $year,
            'genre' => $genre
        )
    ));
}

if (empty($GetDataInput)) {
    echo json_encode(array(
        'results' => array(
            'artist' => $defaultArtist,
            'title' => $defaultTitle,
            'artwork' => $defaultArtwork
        )
    ));
} elseif ($ApiType === "deezer") {
    echo getDeezer($FilterReplace, $defaultArtist, $defaultTitle, $defaultArtwork);
}
